/*
 * Decompiled with CFR 0.152.
 */
package de.stahl.kopiermaschine;

import de.stahl.kopiermaschine.KeyManager;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Base64;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RequestManager {
    private final OkHttpClient httpClient = new OkHttpClient();
    private final Request keyRetrieveRequest;
    private final Request.Builder keySendRequestBuilder;
    private final Request contentRequest;
    private final Request contentTimestampRequest;
    private final Request.Builder sendContentRequestBuilder;
    private KeyManager keyManager;

    public RequestManager(String serverUrl, String clientId, String deviceId, String serverPathKeyExchange, String serverPathContent, String serverPathContentTimestamp, String serverPathSendContent) {
        this.keyRetrieveRequest = new Request.Builder().url(serverUrl + serverPathKeyExchange).header("client-id", clientId).header("device-id", deviceId).build();
        this.keySendRequestBuilder = new Request.Builder().url(serverUrl + serverPathKeyExchange).header("client-id", clientId).header("device-id", deviceId);
        this.contentRequest = new Request.Builder().url(serverUrl + serverPathContent).header("client-id", clientId).header("device-id", deviceId).build();
        this.contentTimestampRequest = new Request.Builder().url(serverUrl + serverPathContentTimestamp).header("client-id", clientId).header("device-id", deviceId).build();
        this.sendContentRequestBuilder = new Request.Builder().url(serverUrl + serverPathSendContent).header("client-id", clientId).header("device-id", deviceId);
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public String retrieveOtherPublicKey() {
        try {
            Response response = this.httpClient.newCall(this.keyRetrieveRequest).execute();
            if (!response.isSuccessful()) {
                return null;
            }
            String base64KeyBytes = response.body().string();
            if (base64KeyBytes == null || base64KeyBytes.equals("")) {
                return null;
            }
            return base64KeyBytes;
        }
        catch (IOException e) {
            System.out.println("Error calling kopiermaschine server for other public key");
            return null;
        }
    }

    public boolean sendOwnPublicKey(String base64KeyBytes) {
        try {
            Request keySendRequest = this.keySendRequestBuilder.method("POST", RequestBody.create(base64KeyBytes, MediaType.get("text/plain"))).build();
            Response response = this.httpClient.newCall(keySendRequest).execute();
            return response.isSuccessful();
        }
        catch (IOException e) {
            System.out.println("Error sending own public key to kopiermaschine server");
            return false;
        }
    }

    public String requestContentTimestamp() {
        try {
            Response response = this.httpClient.newCall(this.contentTimestampRequest).execute();
            if (!response.isSuccessful()) {
                return null;
            }
            String timestamp = response.body().string();
            if (timestamp == null || timestamp.equals("")) {
                return null;
            }
            return timestamp;
        }
        catch (IOException e) {
            System.out.println("Error calling kopiermaschine server for content timestamp");
            return null;
        }
    }

    public RequestResult requestContent() {
        byte[] content;
        byte[] aesEncryptedContent;
        byte[] rsaEncryptedAesPasswordSaltIv;
        String contentType;
        try {
            Response response = this.httpClient.newCall(this.contentRequest).execute();
            if (!response.isSuccessful()) {
                return null;
            }
            contentType = "text/plain";
            if (response.header("content-type") != null && !response.header("content-type").equals("")) {
                contentType = response.header("content-type");
            }
            String responseBody = new String(response.body().bytes());
            rsaEncryptedAesPasswordSaltIv = Base64.getDecoder().decode(responseBody.substring(0, responseBody.indexOf("|")));
            aesEncryptedContent = Base64.getDecoder().decode(responseBody.substring(responseBody.indexOf("|") + 1));
        }
        catch (IOException e) {
            System.out.println("Error calling kopiermaschine server for content");
            return null;
        }
        try {
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            rsaCipher.init(2, this.keyManager.getOwnPrivateKey());
            String aesPasswordSaltIv = new String(rsaCipher.doFinal(rsaEncryptedAesPasswordSaltIv));
            String password = aesPasswordSaltIv.substring(0, aesPasswordSaltIv.indexOf("|"));
            byte[] salt = Base64.getDecoder().decode(aesPasswordSaltIv.substring(aesPasswordSaltIv.indexOf("|") + 1, aesPasswordSaltIv.lastIndexOf("|")));
            byte[] iv = Base64.getDecoder().decode(aesPasswordSaltIv.substring(aesPasswordSaltIv.lastIndexOf("|") + 1));
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 8192, 256);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyFactory.generateSecret(keySpec).getEncoded(), "AES");
            Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            aesCipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            content = aesCipher.doFinal(aesEncryptedContent);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            System.out.println("Could not decrypt received content");
            return null;
        }
        return new RequestResult(contentType, content);
    }

    public boolean sendContent(String contentType, byte[] content) {
        byte[] encryptedContent;
        try {
            String randomPassword = UUID.randomUUID().toString().replaceAll("-", "");
            byte[] randomSalt = new byte[8];
            new SecureRandom().nextBytes(randomSalt);
            PBEKeySpec keySpec = new PBEKeySpec(randomPassword.toCharArray(), randomSalt, 8192, 256);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyFactory.generateSecret(keySpec).getEncoded(), "AES");
            Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            aesCipher.init(1, secretKey);
            AlgorithmParameters algorithmParameters = aesCipher.getParameters();
            byte[] iv = algorithmParameters.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] aesEncryptedContent = aesCipher.doFinal(content);
            String aesPasswordSaltIv = randomPassword + "|" + Base64.getEncoder().encodeToString(randomSalt) + "|" + Base64.getEncoder().encodeToString(iv);
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            rsaCipher.init(1, this.keyManager.getOtherPublicKey());
            byte[] rsaEncryptedAesPasswordSaltIv = rsaCipher.doFinal(aesPasswordSaltIv.getBytes());
            encryptedContent = (Base64.getEncoder().encodeToString(rsaEncryptedAesPasswordSaltIv) + "|" + Base64.getEncoder().encodeToString(aesEncryptedContent)).getBytes();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            System.out.println("Could not encrypt content to send - " + e.getClass().getName());
            return false;
        }
        try {
            Request sendContentRequest = this.sendContentRequestBuilder.header("content-type", contentType).method("POST", RequestBody.create(encryptedContent)).build();
            Response response = this.httpClient.newCall(sendContentRequest).execute();
            return response.isSuccessful();
        }
        catch (IOException e) {
            System.out.println("Error while sending content");
            return false;
        }
    }

    public class RequestResult {
        private final String contentType;
        private final byte[] content;

        public RequestResult(String contentType, byte[] content) {
            this.contentType = contentType;
            this.content = content;
        }

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getContent() {
            return this.content;
        }
    }
}

