/*
 * Decompiled with CFR 0.152.
 */
package de.stahl.kopiermaschine;

import de.stahl.kopiermaschine.KeyManager;
import de.stahl.kopiermaschine.KeySetupFailedException;
import de.stahl.kopiermaschine.RequestManager;
import de.stahl.kopiermaschine.TransferableImage;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Properties;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;

public class Main {
    protected static final String CONFIG_FILENAME = "kopiermaschine-config.txt";
    protected static final String PROPERTY_NAME_MOBILE_DEVICE_ID = "MOBILE_DEVICE_ID";
    protected static final String PROPERTY_NAME_OTHER_PUBLIC_KEY = "OTHER_PUBLIC_KEY";
    protected static final String PROPERTY_NAME_OWN_PRIVATE_KEY = "OWN_PRIVATE_KEY";
    private static final String SERVER_URL = "https://kopiermaschine.lernweiter.de/api";
    private static final String CLIENT_ID = "22dff798-a131-4f78-93e3-6cd2804ac8e9";
    private static final String SERVER_PATH_KEY_EXCHANGE = "/key";
    private static final String SERVER_PATH_CONTENT = "/content";
    private static final String SERVER_PATH_CONTENT_TIMESTAMP = "/content/timestamp";
    private static final String SERVER_PATH_SEND_CONTENT = "/content/other";
    private static final String DATA_FLAVOR_NAME = "kopiermaschine fake data flavor";
    private static final DataFlavor DATA_FLAVOR = new DataFlavor(DATA_FLAVOR_CLASS.class, "kopiermaschine fake data flavor");
    private volatile String lastTimestamp;
    private Timer timer;
    private RequestManager requestManager;
    private Clipboard clipboard;
    private FlavorListener flavorListener;

    public static void main(String[] args2) {
        new Main();
    }

    public Main() {
        System.out.println("kopiermaschine is starting ...");
        File configFile = new File(CONFIG_FILENAME);
        Properties properties = new Properties();
        String mobileDeviceId = "";
        byte[] ownPrivateKeyBytes = null;
        byte[] otherPublicKeyBytes = null;
        try {
            configFile.createNewFile();
            FileInputStream fis = new FileInputStream(CONFIG_FILENAME);
            properties.load(fis);
            fis.close();
            if (!(properties.getProperty(PROPERTY_NAME_MOBILE_DEVICE_ID) == null || properties.getProperty(PROPERTY_NAME_MOBILE_DEVICE_ID).equals("") || properties.getProperty(PROPERTY_NAME_OWN_PRIVATE_KEY) == null || properties.getProperty(PROPERTY_NAME_OWN_PRIVATE_KEY).equals("") || properties.getProperty(PROPERTY_NAME_OTHER_PUBLIC_KEY) == null || properties.getProperty(PROPERTY_NAME_OTHER_PUBLIC_KEY).equals(""))) {
                mobileDeviceId = properties.getProperty(PROPERTY_NAME_MOBILE_DEVICE_ID);
                ownPrivateKeyBytes = Base64.getDecoder().decode(properties.getProperty(PROPERTY_NAME_OWN_PRIVATE_KEY));
                otherPublicKeyBytes = Base64.getDecoder().decode(properties.getProperty(PROPERTY_NAME_OTHER_PUBLIC_KEY));
            }
        }
        catch (IOException e) {
            System.out.println("Error reading the config file");
            e.printStackTrace();
            System.exit(1);
        }
        if (!mobileDeviceId.equals("")) {
            System.out.println("\nUsing device id [" + mobileDeviceId + "]");
            this.requestManager = new RequestManager(SERVER_URL, CLIENT_ID, mobileDeviceId, SERVER_PATH_KEY_EXCHANGE, SERVER_PATH_CONTENT, SERVER_PATH_CONTENT_TIMESTAMP, SERVER_PATH_SEND_CONTENT);
            try {
                this.requestManager.setKeyManager(new KeyManager(ownPrivateKeyBytes, otherPublicKeyBytes, this.requestManager));
            }
            catch (KeySetupFailedException e) {
                System.out.println("Key setup failed");
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            System.out.println("\nEnter the kopiermaschine device id from your mobile device here:");
            System.out.print("\n> ");
            Scanner scanner = new Scanner(System.in);
            mobileDeviceId = scanner.nextLine();
            if (mobileDeviceId.equals("")) {
                System.out.println("This is not a valid device id");
                System.exit(1);
            }
            properties.setProperty(PROPERTY_NAME_MOBILE_DEVICE_ID, mobileDeviceId);
            try {
                FileOutputStream fos = new FileOutputStream(CONFIG_FILENAME);
                properties.store(fos, "");
                fos.close();
            }
            catch (IOException e) {
                System.out.println("Error writing the config file");
                e.printStackTrace();
                System.exit(1);
            }
            this.requestManager = new RequestManager(SERVER_URL, CLIENT_ID, mobileDeviceId, SERVER_PATH_KEY_EXCHANGE, SERVER_PATH_CONTENT, SERVER_PATH_CONTENT_TIMESTAMP, SERVER_PATH_SEND_CONTENT);
            try {
                this.requestManager.setKeyManager(new KeyManager(null, null, this.requestManager));
            }
            catch (KeySetupFailedException e) {
                System.out.println("Key setup failed");
                e.printStackTrace();
                System.exit(1);
            }
            System.out.println("\nSetup is complete!");
        }
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.flavorListener = event -> {
            PrintStream errStream = System.err;
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }));
            final Transferable transferable = this.clipboard.getContents(null);
            System.setErr(errStream);
            if (transferable == null) {
                System.out.println("Cannot read copied data from clipboard");
                return;
            }
            if (transferable.isDataFlavorSupported(DATA_FLAVOR)) {
                return;
            }
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            final DataFlavor[] extendedDataFlavors = new DataFlavor[flavors.length + 1];
            for (int i = 0; i < flavors.length; ++i) {
                extendedDataFlavors[i] = flavors[i];
            }
            extendedDataFlavors[flavors.length] = DATA_FLAVOR;
            Transferable wrappedTransferable = new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return extendedDataFlavors;
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    if (Main.DATA_FLAVOR_NAME.equals(flavor.getHumanPresentableName())) {
                        return true;
                    }
                    return transferable.isDataFlavorSupported(flavor);
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (Main.DATA_FLAVOR_NAME.equals(flavor.getHumanPresentableName())) {
                        return new DATA_FLAVOR_CLASS();
                    }
                    return transferable.getTransferData(flavor);
                }
            };
            this.clipboard.setContents(wrappedTransferable, null);
            String contentTypeToExchange = null;
            byte[] bytesToExchange = null;
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                contentTypeToExchange = "text/plain";
                try {
                    String content = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    bytesToExchange = content.getBytes("UTF-8");
                }
                catch (UnsupportedFlavorException | IOException e) {
                    System.out.println("Error while reading copied string data from clipboard");
                }
            } else if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                contentTypeToExchange = "image/jpeg";
                try {
                    BufferedImage content = (BufferedImage)transferable.getTransferData(DataFlavor.imageFlavor);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)content, "jpeg", baos);
                    bytesToExchange = baos.toByteArray();
                    baos.close();
                }
                catch (UnsupportedFlavorException | IOException e) {
                    System.out.println("Error while reading copied image data from clipboard");
                }
            } else {
                System.out.println("Unsupported format of copied data");
            }
            if (bytesToExchange == null) {
                return;
            }
            if (bytesToExchange.length > 10500000) {
                System.out.println("Content to exchange is too big");
                return;
            }
            if (this.requestManager.sendContent(contentTypeToExchange, bytesToExchange)) {
                System.out.println("Copied " + bytesToExchange.length + " bytes of " + contentTypeToExchange);
            } else {
                System.out.println("Could not send copied content");
            }
        };
        this.clipboard.addFlavorListener(this.flavorListener);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new ContentRequester(), 1000L);
        System.out.println("\nkopiermaschine is now listening to new copied data ...\n");
    }

    private class ContentRequester
    extends TimerTask {
        private ContentRequester() {
        }

        @Override
        public void run() {
            String timestamp = Main.this.requestManager.requestContentTimestamp();
            if (timestamp == null) {
                Main.this.lastTimestamp = null;
                Main.this.timer.schedule((TimerTask)new ContentRequester(), 1000L);
                return;
            }
            if (timestamp.equals(Main.this.lastTimestamp)) {
                Main.this.timer.schedule((TimerTask)new ContentRequester(), 1000L);
                return;
            }
            Main.this.lastTimestamp = timestamp;
            RequestManager.RequestResult requestResult = Main.this.requestManager.requestContent();
            if (requestResult == null) {
                Main.this.timer.schedule((TimerTask)new ContentRequester(), 1000L);
                return;
            }
            if (requestResult.getContentType().startsWith("text/")) {
                String textForClipboard;
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                try {
                    textForClipboard = new String(requestResult.getContent(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("Could not use UTF-8 encoding");
                    Main.this.timer.schedule((TimerTask)new ContentRequester(), 1000L);
                    return;
                }
                clipboard.removeFlavorListener(Main.this.flavorListener);
                clipboard.setContents(new StringSelection(textForClipboard), null);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    System.out.println("Interrupted while waiting for insertion to clipboard");
                }
                clipboard.addFlavorListener(Main.this.flavorListener);
                System.out.println("Received " + requestResult.getContent().length + " bytes of " + requestResult.getContentType());
            } else if (requestResult.getContentType().startsWith("image/")) {
                BufferedImage bufferedImage;
                try {
                    BufferedImage bufferedImageTemp = ImageIO.read(new ByteArrayInputStream(requestResult.getContent()));
                    bufferedImage = new BufferedImage(bufferedImageTemp.getWidth(), bufferedImageTemp.getHeight(), 1);
                    bufferedImage.getGraphics().drawImage(bufferedImageTemp, 0, 0, null);
                }
                catch (IOException e) {
                    System.out.println("Cannot work with received image data of type [" + requestResult.getContentType() + "]");
                    Main.this.timer.schedule((TimerTask)new ContentRequester(), 1000L);
                    return;
                }
                boolean saved = false;
                String homeDir = System.getProperty("user.home");
                if (homeDir == null || homeDir.equals("")) {
                    System.out.println("Cannot get user home directory, so cannot save received image to file");
                } else {
                    String newImageFilename = homeDir + "/Downloads/kopiermaschine-" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS").format(new Date()) + ".jpg";
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, "jpeg", new File(newImageFilename));
                        saved = true;
                    }
                    catch (IOException e) {
                        System.out.println("Cannot save received image to downloads folder");
                    }
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.removeFlavorListener(Main.this.flavorListener);
                clipboard.setContents(new TransferableImage(bufferedImage), null);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    System.out.println("Interrupted while waiting for insertion to clipboard");
                }
                clipboard.addFlavorListener(Main.this.flavorListener);
                System.out.println("Received " + (saved ? "and saved " : "") + requestResult.getContent().length + " bytes of " + requestResult.getContentType());
            } else {
                System.out.println("Cannot handle received content of type [" + requestResult.getContentType() + "]");
            }
            Main.this.timer.schedule((TimerTask)new ContentRequester(), 1000L);
        }
    }

    private static final class DATA_FLAVOR_CLASS {
        private DATA_FLAVOR_CLASS() {
        }
    }
}

